# script to extract csv files from the SQLite databse.


library(RSQLite)

# path to write the csv files:
path = "./KielBay_DB(2)"

# path to the database file (.sqlite):
path.db = "./KielBay_DB(2)/KielBay_DB.sqlite"

# create the connection to the database file
mydb <- dbConnect(RSQLite::SQLite(), path.db)

# create the fish.content table (information on fish identity and prey items found in the different stomachs)

stoms = dbGetQuery(mydb,
                      "SELECT *
                       FROM Stomach_content
                       ")
head(stoms)


preds = dbGetQuery(mydb,
                   "SELECT *
                    FROM Predators_individuals
                    ")
head(preds)


#########################################################
### table with fish and their stomach contents ##########
#########################################################

stomachs = dbGetQuery(mydb,
                      "SELECT *
                       FROM Predators_individuals
                       INNER JOIN Stomach_content
                       ON Predators_individuals.ID_predators_individuals = Stomach_content.ID_predators_individuals
                       INNER JOIN Prey_species
                       ON Stomach_content.ID_Prey_species = Prey_species.ID_Prey_species
                       INNER JOIN Stomach_parts
                       ON Stomach_content.ID_stomach_parts = Stomach_parts.ID_Stomach_parts
                       INNER JOIN Sampling
                       ON Sampling.ID_Sampling = Predators_individuals.ID_Sampling
                       INNER JOIN Trawlings
                       ON Trawlings.ID_Trawling_Locations = Sampling.ID_Trawling_Locations
                       INNER JOIN Dates
                       ON Sampling.ID_dates = Dates.ID_Dates
                       INNER JOIN Species
                       ON Predators_individuals.ID_Species = Species.ID_Species
                                            ")

head(stomachs)

bb = names(stomachs)

# remove non necessary columns
to.keep = c(1,3,4,5,6,16, 11, 12, 14, 17,21, 24)
to.keep = c(1,4,10, 11, 13, 15, 20, 22,23,25,27)



fish.diet = stomachs[,to.keep]
names(fish.diet)
names(fish.diet)[5] = "name_prey"
names(fish.diet)[11] = "name_pred"
unique(fish.diet$Latin_name)


#####################################################
####### table for the benthic community #############
#####################################################

benthos = dbGetQuery(mydb,
                      "SELECT *
                       FROM Benthos_community
                       INNER JOIN Species
                       ON Benthos_community.ID_species = Species.ID_species
                       INNER JOIN Sampling
                       ON Benthos_community.ID_sampling = Sampling.ID_sampling
                       INNER JOIN Trawlings
                       ON Trawlings.ID_Trawling_Locations = Sampling.ID_Trawling_Locations
                       INNER JOIN Dates
                       ON Dates.ID_dates = Sampling.ID_dates
                                            ")

names(benthos)
unique(cbind.data.frame(benthos$ID_date, benthos$date))


to.keep = c(7,4,5,8,12,14,15,17)
benthic.community = benthos[,to.keep]
names(benthic.community)

i = unique(benthic.community$ID_sampling)[1]
tab = benthic.community[benthic.community$ID_sampling == i, ]
tab
#


#####################################################
####### table for Trawling loc. infos   #############
#####################################################

trawlings.all = dbGetQuery(mydb,
                     "SELECT *
                       FROM Sampling
                       INNER JOIN Trawlings
                       ON Trawlings.ID_Trawling_Locations = Sampling.ID_Trawling_Locations
                       INNER JOIN Dates
                       ON Sampling.ID_dates = Dates.ID_dates
")
names(trawlings.all)
to.keep = c(5,6,7,8,10)
trawlings = trawlings.all[,to.keep]
names(trawlings)
#####################################################
####### table for environment conditions   ##########
#####################################################

environment = dbGetQuery(mydb,
                       "SELECT *
                       FROM Dates
                       INNER JOIN Salinity
                       ON Dates.ID_dates = Salinity.Id_Dates
                       INNER JOIN Temperature
                       ON Dates.ID_dates = Temperature.ID_Dates
")
names(environment)
# remove non necessary columns
to.keep = c(2, 5, 8)
environment = environment[to.keep]



write.csv(fish.diet, paste(path,  "Fish_Diet.csv", sep = ""),
          row.names = FALSE,
          fileEncoding = "UTF-8")
write.csv(benthic.community,
            paste(path,  "Benthic_Community.csv", sep = ""),
            row.names = FALSE,
            fileEncoding = "UTF-8")
write.csv(trawlings, paste(path,  "trawlings.csv", sep = ""),
            row.names = FALSE,
          fileEncoding = "UTF-8")
write.csv(environment, paste(path,  "environment.csv", sep = ""),
            row.names = FALSE,
            fileEncoding = "UTF-8")



dbDisconnect(mydb)
